﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using Microsoft.Practices.EnterpriseLibrary.Data;

[Serializable]
public static class SqlProvider
{
    /// <summary>
    /// PerformUpdate:  This function will perform an update to the database with the given
    /// sql query.
    /// </summary>
    /// <param name="sqlStatement">the query to run </param>
    /// <returns>and integer result.  0 if no errors.</returns>
    public static int PerformUpdate(string connName, string spName, params object[] values)
    {
        if (connName.Length > 0)
        {

            int result = 0;
            try
            {
                Database db = DatabaseFactory.CreateDatabase(connName);
                DbCommand dbCommand = db.GetStoredProcCommand(spName, values);
                result = db.ExecuteNonQuery(dbCommand);
            }
            catch (Exception ex)
            {
       
            }
            return result;
        }
        else
        {
            return -1;
        }
    }

    public static int PerformInsert(string connName, string spName, params object[] values)
    {
        int result = -1;
        if (connName.Length > 0)
        {
            try
            {
                Database db = DatabaseFactory.CreateDatabase(connName);
                DbCommand dbCommand = db.GetStoredProcCommand(spName, values);
                result = db.ExecuteNonQuery(dbCommand);
            }
            catch (Exception ex)
            {
                
            }
        }
        return result;
    }
    public static int PerformDelete(string connName, string spName, params object[] values)
    {
        int result = -1;
        if (connName.Length > 0)
        {
            try
            {
                Database db = DatabaseFactory.CreateDatabase(connName);
                DbCommand dbCommand = db.GetStoredProcCommand(spName, values);
                result = db.ExecuteNonQuery(dbCommand);
            }
            catch (Exception ex)
            {
                
            }
        }
        return result;
    }


    /// <summary>
    /// ExecuteSPDataset: This function will perform a select call within the database.
    /// </summary>
    /// <param name="sqlStatement">the query to execute within the database.</param>
    /// <returns>A dataset, or null if nothing is returned.</returns>
    public static DataSet ExecuteSPDataset(string connName, string spName, params object[] values)
    {
        if (connName.Length > 0)
        {
            DataSet ds = null;
            try
            {
                ds = new DataSet();
                Database db = DatabaseFactory.CreateDatabase(connName);
                DbCommand dbCommand = db.GetStoredProcCommand(spName, values);
                ds = db.ExecuteDataSet(dbCommand);
            }
            catch (Exception ex)
            {

            }
            return ds;
        }
        else
            return null;
    }

    public static DataTable ExecuteSPDataTable(string connName, string spName, params object[] values)
    {
        if (connName.Length > 0)
        {
            DataTable dt = null;
            DataSet ds = null;
            try
            {
                dt = new DataTable();
                ds = ExecuteSPDataset(connName, spName, values);
                if ((ds != null) && ds.Tables.Count > 0)
                    dt = ds.Tables[0];
                else
                    dt = null;
            }
            catch (Exception ex)
            {
         
            }
            finally
            {
                ds.Dispose();
            }
            return dt;
        }
        else
            return null;

    }
    public static SqlDataReader ExecuteSPReader(string connName, string spName, params object[] values)
    {
        SqlDataReader dr = null;
        if (connName.Length > 0)
        {

            try
            {
                Database db = DatabaseFactory.CreateDatabase(connName);
                DbCommand dbCommand = db.GetStoredProcCommand(spName, values);
                dr = (SqlDataReader)db.ExecuteReader(dbCommand);

            }
            catch (Exception ex)
            {
          
            }
        }
        return dr;
    }
    public static object ExecuteScalar(string connName, string spName, params object[] values)
    {
        object result = null;
        if (connName.Length > 0)
        {

            try
            {
                Database db = DatabaseFactory.CreateDatabase(connName);
                DbCommand dbCommand = db.GetStoredProcCommand(spName, values);
                result = db.ExecuteScalar(dbCommand);
            }
            catch (Exception ex)
            {
              
            }
        }
        return result;
    }
    public static object ExecuteFunction(string connName, string fnName)
    {
        object toReturn = null;
        if (connName.Length > 0)
        {
            try
            {
                Database db = DatabaseFactory.CreateDatabase(connName);
                DbCommand dbCommand = db.GetSqlStringCommand(fnName);
                toReturn = db.ExecuteScalar(dbCommand);
            }
            catch (Exception ex)
            {
          
            }
        }
        return toReturn;
    }

    /// <summary>
    /// Performs the data set operations.
    /// </summary>
    /// <param name="toPerform">To perform.</param>
    /// <param name="insertCommand">The insert command.</param>
    /// <param name="updateCommand">The update command.</param>
    /// <param name="deleteCommand">The delete command.</param>
    /// <returns></returns>
    public static bool PerformDataSetOperations(string connName, DataSet toPerform, DbCommand insertCommand, DbCommand updateCommand, DbCommand deleteCommand)
    {
        bool toReturn = false;
        Database db = DatabaseFactory.CreateDatabase(connName);
        IDbConnection connection = db.CreateConnection();
        connection.Open();
        IDbTransaction transaction = connection.BeginTransaction();
        try
        {
            //int rowsAffected = db.UpdateDataSet(toPerform,  
        }
        catch (Exception ex)
        {
            
        }
        finally
        {

        }
        return toReturn;
    }

    public static DataTable SimplePivotDataTable(DataTable table, string columnX,
                                                 params string[] columnsToIgnore)
    {
        //Create a DataTable to Return
        DataTable returnTable = new DataTable();

        if (columnX == String.Empty)
            columnX = table.Columns[0].ColumnName;

        //Add a Column at the beginning of the table

        returnTable.Columns.Add(columnX);

        //Read all DISTINCT values from columnX Column in the provided DataTale
        List<string> columnXValues = new List<string>();

        //Creates list of columns to ignore
        List<string> listColumnsToIgnore = new List<string>();
        if (columnsToIgnore.Length > 0)
            listColumnsToIgnore.AddRange(columnsToIgnore);

        if (!listColumnsToIgnore.Contains(columnX))
            listColumnsToIgnore.Add(columnX);

        foreach (DataRow dr in table.Rows)
        {
            string columnXTemp = dr[columnX].ToString();
            //Verify if the value was already listed
            if (!columnXValues.Contains(columnXTemp))
            {
                //if the value id different from others provided, add to the list of 
                //values and creates a new Column with its value.
                columnXValues.Add(columnXTemp);
                returnTable.Columns.Add(columnXTemp);
            }
            else
            {
                //Throw exception for a repeated value
                //throw new Exception("The inversion used must have unique values for column " + columnX);
            }
        }

        //Add a line for each column of the DataTable

        foreach (DataColumn dc in table.Columns)
        {
            if (!columnXValues.Contains(dc.ColumnName) && !listColumnsToIgnore.Contains(dc.ColumnName))
            {
                DataRow dr = returnTable.NewRow();
                dr[0] = dc.ColumnName;
                returnTable.Rows.Add(dr);
            }
        }

        //Complete the datatable with the values
        for (int i = 0; i < returnTable.Rows.Count; i++)
        {
            for (int j = 1; j < returnTable.Columns.Count; j++)
            {
                returnTable.Rows[i][j] = table.Rows[j - 1][returnTable.Rows[i][0].ToString()].ToString();
            }
        }

        return returnTable;
    }
}
